 ; Ŀ
 ;   Spray: apply text to an entity.                                       
 ;   Copyright 1991, 2005 by Rocket Software Ltd.                          
 ;   A program of a thousand uses, most of them completely impractical.    
 ;   Numbers 615-628 are illegal in some areas but who really cares?       
 ; 

 ; Ŀ
 ;   Subroutine Alpha - increment a character string.                      
 ;   Takes one argument, a string.  Returns the incremented version.       
 ; 
 (DEFUN ALPHA (cname / pos char base cname cnamp chasci)
  (setq pos (strlen cname))
  (while (and (>= pos 1)
              (setq char (substr cname pos 1))
              (<= 90 (ascii char)))
         (setq pos (1- pos)))
 ; Ŀ
 ;   If no non-z characters were found, set all to 0 and add an 0 to the   
 ;   left end of the string.                                               
 ; 
  (cond ((= pos 0)
         (setq base "")
         (repeat (1+ (strlen cname))
                 (setq base (strcat base "0")))
         (setq cname base))
 ; Ŀ
 ;   If a non-Z was found, everything to the right of it becomes a 0, and  
 ;   it is incremented.                                                    
 ; 
        (T (setq cnamp cname)
           (setq cname (strcat (substr cnamp 1 (1- pos))))
           (setq char (chr (1+ (ascii (substr cnamp pos 1)))))
           (setq chasci (ascii char))
           (if (and (>= chasci 58) (<= chasci 64))
               (setq char "A"))
           (setq base "")
           (repeat (strlen (substr cnamp (1+ pos)))
                   (setq base (strcat base "0")))
           (setq cname (strcat cname char base))))
 cname)
 ; Ŀ
 ;   Alpha end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Blampe: make a block.                                      
 ;   Takes three arguments: Bnam, the block name,                          
 ;                          Rota, the text rotation in degrees,            
 ;                          Str,  the string the block will contain,       
 ;                          Hi,   the text height.                         
 ;                          Jj,   the text justification.                  
 ;   Returns to the same nesting spot year after year.                     
 ; 
 (DEFUN BLAMPE (bnam rota str hi jj / tt fh elast entt hip)
  (setq tt (getvar "textstyle"))
  (setq fh (cdr (assoc 40 (tblsearch "style" tt))))
  (if (= fh 0.0)
      (if (= jj "L")
          (command "text" "0,0" "" rota str)
          (command "text" jj "0,0" "" rota str))
      (if (= jj "L")
          (command "text" "0,0" rota str)
          (command "text" jj "0,0" rota str)))
  (setq entt (entget (setq elast (entlast))))
  (entmod (subst (cons 40 hi) (assoc 40 entt) entt))
  (if (tblsearch "block" bnam)
      (command "block" bnam "y" "0,0" elast "")
      (command "block" bnam "0,0" elast ""))
 (princ))
 ; Ŀ
 ;   Blampe end.                                                           
 ; 
 ; Ŀ
 ;   Clent - get a line from a text file.                                  
 ; 
 (DEFUN CLENT (filnam / dalisa linn)
 ; Ŀ
 ;   Read the cdf file into a list.                                        
 ; 
 (setq dalisa (cdfl filnam))
 ; Ŀ
 ;   Get a text string.                                                    
 ; 
 (cdfbox dalisa filnam))
 ; Ŀ
 ;   Clent end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Cdfbox - display a list of strings in a dialog box.        
 ;   Arguments: Fildat, the list.                                          
 ;              Filnam, the data file name.                                
 ;   Returns a text string.                                                
 ; 
 (DEFUN CDFBOX (fildat filnam / dcl_id num numf csvlin malist findx ret)
  (setq dcl_id (load_dialog "lent.dcl"))
  (new_dialog "lent" dcl_id)     ; must come before data for list box
 ; Ŀ
 ;   Make the csv line list for the list box.                              
 ; 
  (start_list "the_list")        ; read fildata into list box
  (setq num 0)
  (setq numf 0)                  ; lines in file
  (while (setq csvlin (nth num fildat))
         (if (/= (substr csvlin 1 1) ";")
             (progn
                  (setq numf (1+ numf))
                  (add_list csvlin)
                  (setq malist (cons csvlin malist))))
         (setq num (1+ num)))
  (end_list)
  (setq malist (reverse malist))
  (set_tile "babtext" (strcat (itoa numf) " line"
                              (if (= numf 1) "" "s")
                              " in file: " filnam))
 ; Ŀ
 ;   Actions for given buttons/selections.  Must come after New_dialog     
 ;   call and before Start_dialog.                                         
 ; 
  (action_tile "select_ok" "(setq findx (csvok $reason))")
  (action_tile "the_list" "(setq findx (lisok $reason))")
  (action_tile "fcancel" "(setq findx ())")
 ; Ŀ
 ;   Run it.                                                               
 ; 
  (setq ret (start_dialog))
  (unload_dialog dcl_id)
 ; Ŀ
 ;   Return a csv string or nil.                                           
 ; 
 (if (and findx (/= findx ""))
     (nth (read findx) malist) nil))
 ; Ŀ
 ;   Cdfbox end.                                                           
 ; 

 ; Ŀ
 ;   Cdfl: read a datafile into a list of strings.                         
 ;   Takes one argument, the file name.                                    
 ;   Returns a list containing either the contents of the file or - if     
 ;   it wasn't found - the name of the current drawing.                    
 ; 
 (DEFUN CDFL (fnam / fn filstr namlst cnam namm namls2)
 ; Ŀ
 ;   If the datafile can be opened then read the lines into a list.        
 ;   Ignore empty lines.                                                   
 ; 
  (if (setq fn (open fnam "r"))
      (progn
           (while (setq filstr (read-line fn))
                  (while (= (substr filstr 1 1) " ")
                         (setq filstr (substr filstr 2)))
                  (if (/= filstr "")
                      (setq namlst (append namlst (list filstr)))))
           (close fn)))
 namlst)
 ; Ŀ
 ;   Cdfl end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Cmake: make a circle.                                      
 ;   If no entity is selected for division construct a circle large        
 ;   enough to hold the text string tt.                                    
 ;   If the divide pick point is offscreen then it is panned back on.      
 ;   Takes one argument: tt, a string.                                     
 ;   Returns a list: (pick_point string new_entity_name).                  
 ; 
 (DEFUN CMAKE (tt / pa aa spc tt nnn rr enam a maxx)
  (setq pa ())
  (setq pa (getpoint "Pick centre of circle: "))
  (while (null pa)
         (setq pa (getpoint "Keep trying: ")))
  (if (null aa) (setq aa 1))
  (setq spc (getint (strcat "\nAdd how many spaces between ends? <"
                            (itoa aa) ">: ")))
  (if (null spc) (setq spc aa))
  (repeat (/ spc 2) (setq tt (strcat " " tt " ")))
  (if (= (rem spc 2) 1)
      (setq tt (strcat tt " ")))
  (setq nnn (strlen tt))
  (command "circle" pa (setq rr (/ (* 1.5 nnn) pi)))
  (setq enam (entlast))
  (setq pa (polar pa 0 rr))
  (setq a (getvar "screensize"))           ; view height
  (setq a (/ (car a) (cadr a)))            ; view width/height
  (setq a (* (getvar "viewsize") a 0.5))   ; view half width
  (setq maxx (+ a (car (getvar "viewctr")))) ; view max x coord
  (if (> (car pa) maxx)                    ; if pa offscreen
      (progn
           (setq a (getvar "regenmode"))
           (setvar "regenmode" 1)
           (command "pan" pa (getvar "viewctr"))
           (setvar "regenmode" a)))
 (list pa tt enam))
 ; Ŀ
 ;   Subroutine Cmake end.                                                 
 ; 

 ; Ŀ
 ;   Subroutine Csvok - if OK was pressed, see if a string line was        
 ;   selected, if so exit the dialog box and return the zero based index   
 ;   of that name.  Otherwise show an error.                               
 ; 
 (DEFUN CSVOK (reason / lisval num str len)
  (setq lisval (get_tile "the_list"))
  (if (and lisval (/= lisval ""))
      (done_dialog)
      (set_tile "babtext" "You must select a data line."))
 lisval)
 ; Ŀ
 ;   Csvok end.                                                            
 ; 

 ; Ŀ
 ;   Dget - Get an entity to divide.                                       
 ;   Arguments: tt, a text string.                                         
 ;   Calls Cmake.                                                          
 ;   Returns a list: number of divisions                                   
 ;                   block name (cw / ccw)                                 
 ;                   text string                                           
 ;                   pick point                                            
 ; 
 (DEFUN DGET (tt / nnn ntt pa tt tp nn div up re aa spc)
  (setq nnn (strlen tt))           ; get string length
  (setq ntt (entsel "Entity to divide or <Return> to draw circle:\n"))
  (if (null ntt)
 ; Ŀ
 ;   If no entity was selected then call Cmake to make a circle.           
 ; 
      (progn
           (setq ntt (cmake tt))
           (setq pa (car ntt))
           (setq tt (cadr ntt))
           (setq ntt (caddr ntt))
           (setq tp "CIRCLE"))
 ; Ŀ
 ;   If an entity to divide was selected.                                  
 ; 
      (progn
           (setq nn (entget (car ntt)))   ; get its information
           (setq tp (cdr (assoc 0 nn)))   ; get entity type
           (setq pa (cadr ntt))))         ; get pick point
 ; Ŀ
 ;   The variable Div contains the number to divide with as opposed to     
 ;   the actual number of characters - if an open entity: a line, arc,     
 ;   or open polyline is divided into n spaces then only n-1 character     
 ;   insertions are allowed, so these entities must be divided into n+1    
 ;   sections.                                                             
 ; 
      (cond ((= tp "LINE")
             (setq div (1+ nnn))
             (setq up (getstring "\nPlace text string right way up? <Y>: "))
             (if (> (cadr (assoc 11 nn)) (cadr (assoc 10 nn)))
                 (if (or (= up "") (= up "y") (= up "Y"))
                     (setq re "CCW")
                     (setq re "CW"))
                 (if (or (= up "") (= up "y") (= up "Y"))
                     (setq re "CW")
                     (setq re "CCW"))))
            ((= tp "ARC")
             (setq div (1+ nnn))
             (setq up (getstring "Place text string right way up? <Y>: "))
             (if (or (= up "Y")(= up "y")(= up ""))
                 (setq re "CW")
                 (setq re "CCW")))
            ((= tp "CIRCLE")
             (setq re (getstring "\nWrap clockwise? <Y>: "))
             (if (or (= re "") (= re "y") (= re "Y"))
                 (setq re "CW")
                 (setq re "CCW"))
             (if (null spc)
                 (progn
                      (if (null aa) (setq aa 1))
                      (setq spc (getint (strcat 
                                        "\nAdd how many spaces between ends? <"
                                        (itoa aa) ">: ")))
                      (if (null spc) (setq spc aa))
                      (repeat (/ spc 2) (setq tt (strcat " " tt " ")))
                      (if (= (rem spc 2) 1)
                          (setq tt (strcat tt " ")))))
             (setq div (setq nnn (strlen tt))))
            ((= tp "POLYLINE")
             (setq re (getstring "Wrap from polyline start? <Y>: "))
             (if (or (= re "") (= re "y") (= re "Y"))
                 (setq re "CW")
                 (setq re "CCW"))
             (if (= (rem (cdr (assoc 70 nn)) 2) 1)  ; if a closed polyline
                 (progn
                      (if (null aa) (setq aa 1))
                      (setq spc (getint (strcat 
                                        "\nAdd how many spaces between ends? <"
                                        (itoa aa) ">: ")))
                      (if (null spc) (setq spc aa))
                      (repeat (/ spc 2) (setq tt (strcat " " tt " ")))
                      (if (= (rem spc 2) 1)
                          (setq tt (strcat tt " ")))
                      (setq div (setq nnn (strlen tt))))
                 (setq div (1+ nnn)))))
 (if ntt (list div re tt pa) ()))
 ; Ŀ
 ;   Dget end.                                                             
 ; 

 ; Ŀ
 ;   Dict - returns a list of all named groups.                            
 ; 
 (DEFUN DICT (/ dname nxgrp nxlst grplst)
  (setq dname (namedobjdict))
  (setq nxgrp (dictsearch dname "ACAD_GROUP"))
  (while (setq nxlst (car nxgrp))
         (setq nxgrp (cdr nxgrp))
         (if (= (car nxlst) 3)
             (setq grplst (append grplst (list (cdr nxlst))))))
 grplst)
 ; Ŀ
 ;   Dict end.                                                             
 ; 

 ; Ŀ
 ;   Filto - whole file to string converter.                               
 ;   Arguments: Ff1, a file name.                                          
 ;   Returns a string.                                                     
 ; 
 (defun filto (ff1 / tt aa spc ttn tt fn)
  (setq tt "")
  (setq spc "")
  (setq aa (getint "Place how many spaces between lines? <1>: "))
  (if (null aa) (setq aa 1))
  (repeat aa (setq spc (strcat spc " ")))
  (setq fn (open ff1 "r"))
  (while (setq ttn (read-line fn))
         (setq tt (strcat tt spc ttn)))
  (if aa (setq tt (substr tt (1+ aa))))
  (if tt (write-line (strcat (itoa (strlen tt)) " characters in " ff1)))
  (if fn (Close fn))
 tt)
 ; Ŀ
 ;   Filto end.                                                            
 ; 

 ; Ŀ
 ;   Getsr.                                                                
 ; 
 (DEFUN GETSR (/ tt enampt filnam fread)
 ; Ŀ
 ;   Get a string, or...                                                   
 ; 
  (if (= "" (setq tt (getstring t "Text or <Return> to select: ")))
 ; Ŀ
 ;   Get a text entity or...                                               
 ; 
      (if (null (and (setq enampt (entsel "Text entity or <Return> for file:"))
                     (setq tt (cdr (assoc 1 (entget (car enampt)))))))
 ; Ŀ
 ;   Get a file name.                                                      
 ; 
          (if (setq filnam (getfiled "Text File" "" "" 12))
              (progn
 ; Ŀ
 ;   Ask to read in a line or the whole file.                              
 ; 
                   (initget 0 "Line All File Whole Single Yes No")
                   (setq fread (getstring "Read Whole File N/<Y>: "))
                   (if (member fread '("All" "File" "Whole" "Yes" ""))
                       (setq tt (filto filnam))
                       (setq tt (clent filnam)))))))
 tt)
 ; Ŀ
 ;   Getsr End.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Gnake: group an ss.                                        
 ;   Takes one argument, ss, a selection set.                              
 ;   Calls nothing, returns mothing.                                       
 ; 
 (DEFUN GNAKE (ss / grplst gbase gnam)
 ; Ŀ
 ;   Get all current group names.                                          
 ; 
  (setq grplst (dict))
 ; Ŀ
 ;   Make the group name.                                                  
 ; 
  (if (/= (type gbase) 'STR) (setq gbase "1"))
  (while (member (setq gnam (strcat "SPRAY" gbase)) grplst)
         (setq gbase (alpha gbase)))
  (command "-group" "" gnam "" ss "")
 (princ))
 ; Ŀ
 ;   Subroutine Gnake end.                                                 
 ; 

 ; Ŀ
 ;   Subroutine Lisok - if the list box generated a callback, see if it    
 ;   was a double click or an Enter, in which case return the value of     
 ;   the tile and close the dialog box.                                    
 ; 
 (DEFUN LISOK (reason / lisval)
  (setq lisval (get_tile "the_list"))
  (if (= reason 4)
      (done_dialog)
      (set_tile "babtext" ""))
 lisval)
 ; Ŀ
 ;   Lisok end.                                                            
 ; 

 ; Ŀ
 ;   Rotap - Prompt for letter rotate.                                     
 ;   Returns T = Rotate, or nil.                                           
 ; 
 (DEFUN ROTAP (/ decu)
  (setq decu (getstring "Rotate letters 180? (E=Explain) <N>: "))
  (if (or (= decu "") (= decu "n") (= decu "N"))
      (setq decu ())
      (progn
           (if (or (= decu "E") (= decu "e"))
               (progn
                    (textscr)
(write-line "\n\nThe direction in which the text string is placed onto the")
(write-line "selected entity also controls which way up the text is placed.")
(write-line "If you want to write the text upside down with respect to the")
(write-line "order of placement, as may be required when dealing with oddly")
(write-line "structured polylines or conditions of dangerous boredom, then")
(write-line "you might want to try this option.\n")
                    (if (getstring "<Return> to continue.\n")
                        (graphscr))
                    (setq decu (getstring "So: Rotate? <N>: "))
                    (if (or (= decu "") (= decu "n") (= decu "N"))
                        (setq decu ())
                        (setq decu t)))
               (if (or (= decu "Y") (= decu "y"))
                   (setq decu t)
                   (progn
                        (write-line "Invalid. Letters not rotated.")
                        (setq decu ()))))))
 decu)
 ; Ŀ
 ;   Rotap end.                                                            
 ; 

 ; Ŀ
 ;   Txtc - change text entities to characters in a list.                  
 ;   Arguments: aaa, the first text entity to change.                      
 ;              tt, the list of characters.                                
 ;   Returns an ss of all modified text entities.                          
 ; 
 (DEFUN TXTC (aaa tt / nnn ss dig lln zz)
  (setq nnn (strlen tt))
  (setq ss (ssadd))                 ; stub ss for grouping
  (if (= re "CW")
      (while aaa
            (setq ss (ssadd aaa ss))
            (setq dig (substr tt nnn 1))
            (setq lln (entget aaa))
            (setq zz (cdr (assoc 1 lln)))
            (if (= dig " ")
                (entdel aaa)
                (entmod (subst (cons 1 dig) (cons 1 zz) lln)))
            (setq aaa (entnext aaa))
            (setq nnn (1- nnn)))
      (progn
            (setq nnn 1)
            (while aaa
                   (setq ss (ssadd aaa ss))
                   (setq dig (substr tt nnn 1))
                   (setq lln (entget aaa))
                   (setq zz (cdr (assoc 1 lln)))
                   (if (= dig " ")
                       (entdel aaa)
                       (entmod (subst (cons 1 dig) (cons 1 zz) lln)))
                   (setq aaa (entnext aaa))
                   (setq nnn (1+ nnn)))))
 ss)
 ; Ŀ
 ;   Txtc end.                                                             
 ; 

 ; Ŀ
 ;   Spray.                                                                
 ; 
 (defun C:SPRAY (/ *error* tt desht div pa re decu aaa ss)
  (setvar "cmdecho" 0)
  (command "undo" "be")
 ; Ŀ
 ;   Make an error handler.                                                
 ; 
  (defun *error* (shk)
   (print shk)
   (if tt (write-line (strcat (itoa (strlen tt))
                              " characters in text string.")))
   (command "undo" "end")
  (princ))
 ; Ŀ
 ;   Call Getsr to get a string of text.                                   
 ; 
  (setq tt (getsr))
 ; Ŀ
 ;   Get a desired text height.                                            
 ; 
  (if (null (setq desht (getdist "\nText height <1>: ")))
      (setq desht 1.0))
 ; Ŀ
 ;   Get an entity to divide.                                              
 ; 
  (if (null (setq div (dget tt)))
      (write-line "Cannot divide that entity.")
      (progn
           (setq re (cadr div))
           (setq tt (caddr div))
           (setq pa (nth 3 div))
           (setq div (car div))))
 ; Ŀ
 ;   Can't divide something into 1, so fix things if this is the case.     
 ; 
  (if (= (strlen tt) 1) (setq tt (strcat tt " ") nnn 2 div 2))
 ; Ŀ
 ;   Ask whether to rotate the letters, possibly change the block.         
 ; 
  (setq decu (rotap))
  (if (and decu (= re "CW"))
      (setq re "CCW")
      (setq re "CW"))
 ; Ŀ
 ;   Find the last entity in the drawing.                                  
 ; 
  (setq aaa (entlast))
  (while (entnext aaa)
         (setq aaa (entnext aaa)))
 ; Ŀ
 ;   Ask for a text justification.                                         
 ; 
  (initget 0 "C L M R TL TC TR ML MC MR BL BC BR")
  (if (= "" (setq jj (getstring "Text justification <C>: ")))
      (setq jj "C"))
 ; Ŀ
 ;   Make the desired block, either CCW or CW, as named in Re.             
 ; 
  (if (= re "CW")
      (blampe re 180 "X" desht jj)
      (blampe re 0 "X" desht jj))
 ; Ŀ
 ;   Divide the entity.                                                    
 ; 
  (command "divide" pa "b" re "y" div)
 ; Ŀ
 ;   Find the blocks from the divide command - this will be all inserts    
 ;   after aa.                                                             
 ; 
  (while (/= (cdr (assoc 0 (entget aaa))) "INSERT")
         (setq aaa (entnext aaa)))
 ; Ŀ
 ;   Explode the blocks.                                                   
 ; 
  (while (= (cdr (assoc 0 (entget aaa))) "INSERT")
         (command "explode" aaa)
         (setq aaa (entnext aaa)))
 ; Ŀ
 ;   Call txtc to change them to the desired characters.                   
 ; 
  (setq ss (txtc aaa tt))
 ; Ŀ
 ;   Group the new text entities.                                          
 ; 
  (gnake ss)
  (command "undo" "end")
 (princ))